/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.weapon;

import dev.xkmc.mob_weapon_api.registry.WeaponStatus;
import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.ItemWrapper;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.IRangedWeaponGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.IWeaponGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.WeaponGoalsRegistry;
import java.util.LinkedHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WeaponGoalsManager {
    private final HumanoidGolemEntity golem;
    private final GolemMeleeGoal meleeGoal;
    private final LinkedHashMap<ResourceLocation, WeaponGoalHolder<?>> goals = new LinkedHashMap();
    @Nullable
    private WeaponGoalHolder<?> currentGoal = null;
    private boolean meleeActive = false;

    public WeaponGoalsManager(HumanoidGolemEntity golem) {
        this.golem = golem;
        this.meleeGoal = new GolemMeleeGoal(golem);
    }

    @Nullable
    private WeaponHolder<?> getGoalForWeapon(ItemStack stack, @Nullable InteractionHand hand) {
        WeaponGoalsRegistry.WeaponSearchResult ent = WeaponGoalsRegistry.find((LivingEntity)this.golem, stack, hand);
        if (ent == null) {
            return null;
        }
        if (this.goals.containsKey(ent.id())) {
            return new WeaponHolder(this.golem, stack, this.goals.get(ent.id()), ent.status());
        }
        WeaponGoalHolder ans = new WeaponGoalHolder(ent.id(), ent.entry().goal().create(this.golem, this.meleeGoal));
        this.goals.put(ent.id(), ans);
        return new WeaponHolder(this.golem, stack, ans, ent.status());
    }

    public void reassessWeaponGoal() {
        WeaponHolder<?> ans;
        if (this.golem.m_9236_().f_46443_) {
            return;
        }
        InteractionHand hand = this.golem.getWeaponHand();
        ItemStack weapon = this.golem.m_21120_(hand);
        if (!weapon.m_41619_() && (ans = this.getGoalForWeapon(weapon, hand)) != null) {
            if (this.currentGoal != null) {
                this.golem.f_21345_.m_25363_(this.currentGoal.goal());
            }
            this.currentGoal = ans.holder();
            this.golem.f_21345_.m_25352_(2, this.currentGoal.goal());
            if (!ans.isMelee()) {
                if (this.meleeActive) {
                    this.golem.f_21345_.m_25363_((Goal)this.meleeGoal);
                    this.meleeActive = false;
                }
                return;
            }
        }
        if (!this.meleeActive) {
            this.golem.f_21345_.m_25352_(3, (Goal)this.meleeGoal);
            this.meleeActive = true;
        }
    }

    public void performRangedAttack(LivingEntity target, float power) {
        Object obj;
        if (this.currentGoal != null && (obj = this.currentGoal.goal()) instanceof IRangedWeaponGoal) {
            IRangedWeaponGoal goal = (IRangedWeaponGoal)obj;
            InteractionHand hand = this.golem.getWeaponHand();
            ItemStack stack = this.golem.m_21120_(hand);
            goal.performRangedAttack(this.golem, target, power, stack, hand);
        }
    }

    public boolean checkSwitch(@Nullable LivingEntity target, ItemWrapper mainhand, ItemWrapper offhand) {
        ItemStack main = mainhand.getItem();
        ItemStack off = offhand.getItem();
        WeaponHolder<?> mainGoal = this.getGoalForWeapon(main, null);
        WeaponHolder<?> offGoal = this.getGoalForWeapon(off, null);
        if (mainGoal != null && mainGoal.isRanged()) {
            if (target == null || off.m_41619_() || off.m_41720_() instanceof ArrowItem) {
                return false;
            }
            if (!mainGoal.mayActivate()) {
                return true;
            }
            if (offGoal != null) {
                if (offGoal.priority() > mainGoal.priority() && offGoal.mayActivate() && offGoal.isWithinRange(target, 0.0)) {
                    return true;
                }
                if (!offGoal.isMelee() && offGoal.isRanged()) {
                    return false;
                }
            }
            return this.meleeGoal.canReachTarget(target);
        }
        if (offGoal != null && offGoal.isRanged()) {
            if (!offGoal.mayActivate()) {
                return false;
            }
            if (target == null) {
                return true;
            }
            if (mainGoal != null) {
                if (!mainGoal.isWithinRange(target, 4.0)) {
                    return true;
                }
                if (offGoal.priority() < mainGoal.priority() && mainGoal.mayActivate()) {
                    return false;
                }
            }
            return !this.meleeGoal.canReachTarget(target);
        }
        return main.m_41619_() && !off.m_41619_();
    }

    private record WeaponGoalHolder<T extends Goal>(ResourceLocation id, T goal) {
    }

    private record WeaponHolder<T extends Goal>(HumanoidGolemEntity golem, ItemStack stack, WeaponGoalHolder<T> holder, WeaponStatus status) {
        public T goal() {
            return this.holder().goal();
        }

        public int priority() {
            return this.status().priority();
        }

        public boolean isMelee() {
            return this.status().isMelee();
        }

        public boolean isRanged() {
            return this.status().isRanged();
        }

        public boolean mayActivate() {
            return ((IWeaponGoal)this.goal()).mayActivate(this.golem, this.stack);
        }

        public boolean isWithinRange(LivingEntity target, double buffer) {
            return (double)this.golem.m_20270_((Entity)target) < ((IWeaponGoal)this.goal()).range(this.golem, this.stack) + buffer;
        }
    }
}

